/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class Text2DDrawable
implements Drawable,
Serializable {
    public static final int ABOVE = 3;
    public static final int BELOW = 0;
    public static final int LEFTOF = 1;
    public static final int RIGHTOF = 2;
    String text_;
    Point3D origin_;
    int position_;
    Font font_;
    Color color_;
    int pad_ = 4;

    public Text2DDrawable(String string, Point3D point3D, int n, Color color) {
        this(string, point3D, n, null, color);
    }

    public Text2DDrawable(String string, Point3D point3D, int n) {
        this(string, point3D, n, null, Color.black);
    }

    public Text2DDrawable(String string, Point3D point3D, int n, Font font, Color color) {
        this.text_ = string;
        this.origin_ = point3D;
        this.position_ = n;
        this.font_ = font;
        this.color_ = color;
    }

    public void drawOn(Canvas3D canvas3D, Graphics graphics) {
        int n;
        int n2;
        if (this.font_ == null) {
            graphics.setFont(canvas3D.getFont());
        } else {
            graphics.setFont(this.font_);
        }
        graphics.setColor(this.color_);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(this.text_);
        Point3D point3D = canvas3D.project(this.origin_);
        int n4 = (int)point3D.X();
        int n5 = (int)point3D.Y();
        switch (this.position_) {
            case 3: {
                n2 = (int)((double)n4 - (double)n3 / 2.0 + 0.5);
                n = (int)((double)n5 + 0.5) - this.pad_;
                break;
            }
            case 0: {
                n2 = (int)((double)n4 - (double)n3 / 2.0 + 0.5);
                n = (int)((double)(n5 + fontMetrics.getHeight() - fontMetrics.getMaxDescent()) + 0.5) + this.pad_;
                break;
            }
            case 1: {
                n2 = n4 - n3 - this.pad_;
                n = (int)((double)n5 + (double)fontMetrics.getHeight() / 2.0 + 0.5) - fontMetrics.getMaxDescent();
                break;
            }
            case 2: {
                n2 = n4 + this.pad_;
                n = (int)((double)n5 + (double)fontMetrics.getHeight() / 2.0 + 0.5) - fontMetrics.getMaxDescent();
                break;
            }
            default: {
                System.err.println("Text2DDrawable: Bad or unimplemented position specification");
                return;
            }
        }
        graphics.drawString(this.text_, n2, n);
    }

    public Point3D getOrigin() {
        return this.origin_;
    }

    public String getText() {
        return this.text_;
    }

    public Font getFont() {
        return this.font_;
    }

    public Color getColor() {
        return this.color_;
    }

    public void setJustification(int n) {
        this.position_ = n;
    }
}

